<?php
session_start();
include "include/config.php";

$id = $_GET['id'] ?? 0;

if(!$id){
    header("Location: role_master.php");
    exit;
}

$message = "";

// Fetch role
$stmt = $con->prepare("SELECT * FROM role_master WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$role = $res->fetch_assoc();
$stmt->close();

if(isset($_POST['submit'])){
    $code = trim($_POST['code']);
    $role_name = trim($_POST['role_name']);
    $status = $_POST['status'];
    $modified_by = $_SESSION['id'] ?? 0;
    $modified_on = date("Y-m-d H:i:s");

    // Update query
    $stmt = $con->prepare("UPDATE role_master SET code=?, role_name=?, status=?, modified_by=?, modified_on=? WHERE id=?");
    $stmt->bind_param("ssissi", $code, $role_name, $status, $modified_by, $modified_on, $id);
    if($stmt->execute()){
        $message = "Role updated successfully!";
        header("Location: role_master.php");
    } else {
        $message = "Error: " . $stmt->error;
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Role</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h3>Edit Role</h3>
    <?php if($message): ?>
        <div class="alert <?= strpos($message, 'Error') !== false ? 'alert-danger' : 'alert-success' ?>">
            <?= $message ?>
        </div>
    <?php endif; ?>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">Role Code *</label>
            <input type="text" name="code" class="form-control" required value="<?= htmlspecialchars($role['code']) ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">Role Name *</label>
            <input type="text" name="role_name" class="form-control" required value="<?= htmlspecialchars($role['role_name']) ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select">
                <option value="1" <?= $role['status']==1 ? 'selected' : '' ?>>Active</option>
                <option value="0" <?= $role['status']==0 ? 'selected' : '' ?>>Inactive</option>
            </select>
        </div>
        <button type="submit" name="submit" class="btn btn-primary">Update Role</button>
        <a href="role_master.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>

